<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Appointment extends Model
{
    use HasFactory;

    protected $fillable = [
        'patient_id',
        'doctor_id',
        'pharmacist_id',
        'branch_id',
        'consultation_type',
        'appointment_type',
        'appointment_date',
        'status',
        'video_call_room_id',
        'google_meet_link',
        'additional_medical_notes',
        'pharmacist_signature',
        'client_signature',
    ];

    protected $casts = [
        'appointment_date' => 'datetime',
    ];

    public function patient()
    {
        return $this->belongsTo(Patient::class);
    }

    public function doctor()
    {
        return $this->belongsTo(Doctor::class);
    }

    public function pharmacist()
    {
        return $this->belongsTo(Pharmacist::class);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function vitals()
    {
        return $this->hasOne(Vitals::class);
    }

    public function prescription()
    {
        return $this->hasOne(Prescription::class);
    }

    public function documents()
    {
        return $this->hasMany(PatientDocument::class);
    }

    public function payment()
    {
        return $this->hasOne(Payment::class);
    }
}

